/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SortOrder;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.db.Db;
import jgamebase.db.Export;
import jgamebase.db.Import;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.ItemViewDuplicateUrls;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.gui.ColumnHeader;
import jgamebase.gui.GuiMethods;
import jgamebase.gui.ItemTableModel;
import jgamebase.model.Databases;
import jgamebase.model.Emulators;
import jgamebase.tools.FileTools;

public class Gui
extends GuiMethods {
    private static final long serialVersionUID = -2837268004930852853L;
    public static final int VIEW_ALL_GAMES = 0;
    public static final int VIEW_AVAILABLE_GAMES = 1;
    public static final int VIEW_ALL_MUSIC = 2;
    public static final int VIEW_AVAILABLE_MUSIC = 3;
    public static final int VIEW_FAVOURITES = 4;
    private static ProgressMonitor progressMonitor;
    private static final int step_width = 100;
    private static final String CANCEL_MSG = "CANCEL";

    public Gui() {
        ItemView view;
        this.initViews();
        this.init();
        this.itemTable.getColumnExt((Object)ColumnHeader.YEAR.getName()).setMinWidth(40);
        this.setBounds(Databases.getCurrent().getPreferences().getInt("window_position_x"), Databases.getCurrent().getPreferences().getInt("window_position_y"), Databases.getCurrent().getPreferences().getInt("window_size_x"), Databases.getCurrent().getPreferences().getInt("window_size_y"));
        this.categoriesDialog.setBounds(Databases.getCurrent().getPreferences().getInt("category_position_x"), Databases.getCurrent().getPreferences().getInt("category_position_y"), Databases.getCurrent().getPreferences().getInt("category_size_x"), Databases.getCurrent().getPreferences().getInt("category_size_y"));
        try {
            this.filterViewCombobox.setSelectedIndex(Databases.getCurrent().getPreferences().getInt("selected_view"));
            view = (ItemView)this.filterViewCombobox.getSelectedItem();
        }
        catch (Exception exception) {
            view = (ItemView)this.filterViewCombobox.getItemAt(0);
        }
        view.setSelectedItem(Databases.getCurrent().getPreferences().get("selected_item"));
        ((ItemTableModel)this.itemTable.getModel()).setView(view);
        this.toolsMenu_PlaySoundOnClassics.setSelected(Databases.getCurrent().getPreferences().is("sound_on_classics"));
        this.status5.setIcon(Databases.getCurrent().getPreferences().is("sound_on_classics") ? Const.ICON_SOUND_ON : Const.ICON_SOUND_OFF);
        this.toolsMenu_HardwareJoystick.setSelected(Databases.getCurrent().getPreferences().is("hardware_joystick"));
        this.status6.setIcon(Databases.getCurrent().getPreferences().is("hardware_joystick") ? Const.ICON_JOYSTICK_ON : Const.ICON_JOYSTICK_OFF);
        this.toolsMenu_AdultFilter.setSelected(Databases.getCurrent().getPreferences().is("adult_filter"));
        this.viewMenu_GameDetails.setSelected(Databases.getCurrent().getPreferences().is("display_details"));
        this.infoPanel.setVisible(Databases.getCurrent().getPreferences().is("display_details"));
        this.updateItemTable();
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            Const.log.info((Object)("could not load look and feel " + e));
        }
    }

    public static void scaleFontSize(float multiplier) {
        try {
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration e = defaults.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (!(value instanceof Font)) continue;
                Font font = (Font)value;
                float newSize = Math.round((float)font.getSize() * multiplier);
                Font newFont = font.deriveFont(newSize);
                if (value instanceof FontUIResource) {
                    defaults.put(key, new FontUIResource(newFont));
                    continue;
                }
                defaults.put(key, newFont);
            }
        }
        catch (Exception e) {
            Const.log.info((Object)("could not adjust font size " + e));
        }
    }

    public static int scaleByFontSize(int i) {
        return Math.round((float)i * Const.FONT_SIZE_MULTIPLIER);
    }

    protected static Dimension scaleByFontSize(Dimension dIn) {
        Dimension dOut = new Dimension(dIn);
        float f = 0.75f;
        dOut.setSize(dIn.getWidth() * (double)Const.FONT_SIZE_MULTIPLIER * (double)f, dIn.getHeight() * (double)Const.FONT_SIZE_MULTIPLIER * (double)f);
        if (dOut.getWidth() >= dIn.getWidth() && dOut.getHeight() >= dIn.getHeight()) {
            return dOut;
        }
        return dIn;
    }

    public static Icon scaleByFontSize(Icon icon) {
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            Image image = imageIcon.getImage();
            int currentIconWidth = image.getWidth(null);
            int currentIconHeight = image.getHeight(null);
            int newIconWidth = (int)((float)currentIconWidth * Const.FONT_SIZE_MULTIPLIER);
            int newIconHeight = (int)((float)currentIconHeight * Const.FONT_SIZE_MULTIPLIER);
            if (newIconWidth > currentIconWidth || newIconHeight > currentIconHeight) {
                icon = new ImageIcon(image.getScaledInstance(newIconHeight, newIconHeight, 1));
            }
        }
        return icon;
    }

    protected ItemView getExistingViewByTitle(List<ItemView> list, String title) {
        return list.stream().filter(view -> view.getName().equals(title)).findFirst().orElse(null);
    }

    public void initViews() {
        List<ItemView> dbNormalViews;
        this.dummyView = new ItemView();
        this.dummyView.setInclude(3);
        this.dummyView.setSortOrder(SortOrder.ASCENDING);
        List<ItemView> dbSystemViews = Db.getSystemViews();
        ItemView view = this.getExistingViewByTitle(dbSystemViews, "<All Games>");
        if (view == null) {
            view = new ItemView();
            view.setName("<All Games>");
            view.setType(1);
            view.setInclude(0);
            view.setSortOrder(SortOrder.ASCENDING);
        }
        this.views.add(view);
        view = this.getExistingViewByTitle(dbSystemViews, "<Available Games>");
        if (view == null) {
            view = new ItemView();
            view.setName("<Available Games>");
            view.setType(1);
            view.setInclude(0);
            view.setSortOrder(SortOrder.ASCENDING);
            view.addFilter(new ItemViewFilter(1, 0, "Games", "FA", "", "", ""));
        }
        this.views.add(view);
        view = this.getExistingViewByTitle(dbSystemViews, "<All Music>");
        if (view == null) {
            view = new ItemView();
            view.setName("<All Music>");
            view.setType(1);
            view.setInclude(2);
            view.setSortOrder(SortOrder.ASCENDING);
            view.addFilter(new ItemViewFilter(2, 0, "Games", "SIDFILENAME", "Music", "FILENAME", ""));
            view.setColumnVisibility(new ArrayList<String>(Arrays.asList(ColumnHeader.NAME.getName(), ColumnHeader.YEAR.getName(), ColumnHeader.PUBLISHER.getName(), ColumnHeader.MUSICIAN.getName())));
        }
        this.views.add(view);
        view = this.getExistingViewByTitle(dbSystemViews, "<Available Music>");
        if (view == null) {
            view = new ItemView();
            view.setName("<Available Music>");
            view.setType(1);
            view.setInclude(2);
            view.setSortOrder(SortOrder.ASCENDING);
            view.addFilter(new ItemViewFilter(1, 0, "Games", "SA", "Music", "SA", ""));
            view.setColumnVisibility(new ArrayList<String>(Arrays.asList(ColumnHeader.NAME.getName(), ColumnHeader.YEAR.getName(), ColumnHeader.PUBLISHER.getName(), ColumnHeader.MUSICIAN.getName())));
        }
        this.views.add(view);
        view = this.getExistingViewByTitle(dbSystemViews, "<Favourites (Games and Music)>");
        if (view == null) {
            view = new ItemView();
            view.setName("<Favourites (Games and Music)>");
            view.setType(1);
            view.setInclude(2);
            view.setSortOrder(SortOrder.ASCENDING);
            view.setColumnVisibility(new ArrayList<String>(Arrays.asList(ColumnHeader.NAME.getName(), ColumnHeader.YEAR.getName(), ColumnHeader.PUBLISHER.getName(), ColumnHeader.PROGRAMMER.getName(), ColumnHeader.MUSICIAN.getName())));
            view.addFilter(new ItemViewFilter(3, 0, "Games", "Fav", "Music", "SFav", "-1"));
        }
        this.views.add(view);
        if (JGameBase.option_dangerous) {
            view = new ItemViewDuplicateUrls();
            view.setName("<All Games with URLs and double Name/Publisher>");
            view.setType(1);
            view.setInclude(0);
            view.setSortOrder(SortOrder.ASCENDING);
            this.views.add(view);
        }
        if ((dbNormalViews = Db.getNormalViews()) != null && dbNormalViews.size() > 0) {
            this.views.addAll(dbNormalViews);
        }
    }

    public static boolean singleClick(MouseEvent evt) {
        return evt.getButton() == 1 && evt.getClickCount() == 1;
    }

    public static boolean doubleClick(MouseEvent evt) {
        return evt.getButton() == 1 && evt.getClickCount() == 2;
    }

    public static boolean rightClick(MouseEvent evt) {
        return evt.getButton() == 3 && evt.getClickCount() == 1;
    }

    public static void displayHelpDialog() {
        JOptionPane.showMessageDialog(null, Const.HELP_MSG, "HELP", 1);
    }

    public static void displayUsageDialog() {
        JOptionPane.showMessageDialog(null, Const.USAGE_MSG, "USAGE", 2);
    }

    public static void displayErrorDialog(String s) {
        Const.log.error((Object)s);
        if (!JGameBase.nogui) {
            JOptionPane.showMessageDialog(null, s, "ERROR", 0);
        }
    }

    public static void displayWarningDialog(String s) {
        Const.log.warn((Object)s);
        if (!JGameBase.nogui) {
            JOptionPane.showMessageDialog(null, s, "Warning", 2);
        }
    }

    public static void displayInformationDialog(String s) {
        Const.log.info((Object)s);
        if (!JGameBase.nogui) {
            JOptionPane.showMessageDialog(null, s, "Info", 1);
        }
    }

    public static int displayConfirmationDialog(String s) {
        return JOptionPane.showConfirmDialog(null, s, "jGameBase", 0);
    }

    public ItemTableModel getItemTableModel() {
        return (ItemTableModel)this.itemTable.getModel();
    }

    @Override
    public void quit() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Emulators.stopRunningGames();
        Emulators.stopRunningMusic();
        Databases.getCurrent().getPreferences().set("window_position_x", this.getX());
        Databases.getCurrent().getPreferences().set("window_position_y", this.getY());
        Databases.getCurrent().getPreferences().set("window_size_x", this.getWidth());
        Databases.getCurrent().getPreferences().set("window_size_y", this.getHeight());
        Databases.getCurrent().getPreferences().set("category_position_x", this.categoriesDialog.getX());
        Databases.getCurrent().getPreferences().set("category_position_y", this.categoriesDialog.getY());
        Databases.getCurrent().getPreferences().set("category_size_x", this.categoriesDialog.getWidth());
        Databases.getCurrent().getPreferences().set("category_size_y", this.categoriesDialog.getHeight());
        Databases.getCurrent().getPreferences().set("sidebar_width", this.getSidebarWidth());
        Databases.getCurrent().getPreferences().set("sidebar_h_divider", this.sidePanel_HSplitPane.getDividerLocation());
        Databases.getCurrent().getPreferences().set("sidebar_v_divider", this.sidePanel_VSplitPane.getDividerLocation());
        ItemView currentView = (ItemView)this.filterViewCombobox.getSelectedItem();
        if (currentView.getType() == 2) {
            Databases.getCurrent().getPreferences().set("selected_view", 0);
        }
        Databases.getCurrent().getPreferences().set("selected_view", this.filterViewCombobox.getSelectedIndex());
        ((ItemTableModel)this.itemTable.getModel()).saveGuiParametersToView(currentView);
        Databases.getCurrent().getPreferences().set("selected_item", currentView.getSelectedItem());
        ArrayList changedViews = new ArrayList();
        changedViews.addAll(this.views.stream().filter(view -> view.getType() != 2 && view.isLoaded()).collect(Collectors.toList()));
        if (changedViews.size() > 0) {
            Db.saveOrUpdateAll(changedViews);
        }
    }

    public static void importAccessToDatabase(File file) {
        try {
            int step = 0;
            progressMonitor = new ProgressMonitor(null, "Importing Access database '" + file.getName() + "'", "", 0, 300);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            progressMonitor.setNote("Exporting Access database to csv files");
            progressMonitor.setProgress((++step - 1) * 100 - 1);
            Export.mdb2Csv(file);
            if (progressMonitor.isCanceled()) {
                throw new Exception(CANCEL_MSG);
            }
            progressMonitor.setNote("Creating empty database");
            progressMonitor.setProgress((++step - 1) * 100 - 1);
            Db.init(file.getParentFile().getName(), true);
            if (progressMonitor.isCanceled()) {
                throw new Exception(CANCEL_MSG);
            }
            progressMonitor.setNote("Importing from csv files (this may take a while...)");
            progressMonitor.setProgress((++step - 1) * 100 - 1);
            Import.csv2Db(file);
            if (progressMonitor.isCanceled()) {
                throw new Exception(CANCEL_MSG);
            }
            progressMonitor.setProgress(progressMonitor.getMaximum());
        }
        catch (Exception e) {
            File directory = new File(file.getParentFile().getAbsolutePath(), "Database");
            if (directory.exists()) {
                FileTools.deleteAll(directory);
            }
            if (e != null && e.getMessage() != null && e.getMessage().equals(CANCEL_MSG)) {
                Gui.displayWarningDialog("Access import was canceled.");
            }
            Gui.displayErrorDialog("Access import failed!");
            e.printStackTrace();
        }
    }
}

